<?php
/*--------------------------------------------------------------
   Connection.php 2021-11-01
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\App\Overview\Factory;

use Gambio\Core\UserConfiguration\Services\CurrentUserConfigurationService;
use SleekDB\Store;
use Webmozart\Assert\Assert;

class Connection
{
    private const USER_CONFIGURATION_KEY = "statistics_overview_database";
    
    /**
     * @var CurrentUserConfigurationService
     */
    private $userConfigurationService;
    
    
    /**
     * Constructor.
     */
    public function __construct(CurrentUserConfigurationService $userConfigurationService)
    {
        $this->userConfigurationService = $userConfigurationService;
    }
    
    
    /**
     * Return database connection.
     */
    public function createConnection(string $databaseDirectory): Store
    {
        Assert::directory($databaseDirectory);
        
        $databaseId = $this->userConfigurationService->getValue(self::USER_CONFIGURATION_KEY);
        
        if ($databaseId === null) {
            $databaseId = bin2hex(random_bytes(16));
            $this->userConfigurationService->storeConfiguration(self::USER_CONFIGURATION_KEY, $databaseId);
        }
        
        return new Store($databaseId, $databaseDirectory, ["timeout" => false]);
    }
}